<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Collection;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Collection\CollectionModel;
use Erlage\Photogram\Data\Models\Collection\CollectionValidator;
use Erlage\Photogram\Data\Dtos\Collection\CollectionDisplayImageDTO;

final class CollectionTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'collection';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    const ID = 'id';

    // ids

    const OWNER_USER_ID = 'owner_user_id';

    // display

    const DISPLAY_TITLE = 'display_title';

    const DISPLAY_IMAGE = 'display_image';

    // stamp

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    // extra fields(not present in database)

    const EXTRA_COVER_POST_ID = 'extra_cover_post_id';

    const EXTRA_COVER_POST_SAVE_ID = 'extra_cover_postsave_id';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID => 'id',

        self::OWNER_USER_ID => 'ownerUserId',

        self::DISPLAY_TITLE => 'displayTitle',
        self::DISPLAY_IMAGE => 'displayImage',

        self::STAMP_REGISTRATION => 'stampRegistration',
        self::STAMP_LAST_UPDATE  => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::OWNER_USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return CollectionModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function validators(): array
    {
        return array(
            self::DISPLAY_TITLE => array(CollectionValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_TITLE]),
        );
    }

    public static function serializers(): array
    {
        return array(
            self::DISPLAY_IMAGE => CollectionDisplayImageDTO::serializer(),
        );
    }

    public static function deSerializers(): array
    {
        return array(
            self::DISPLAY_IMAGE => CollectionDisplayImageDTO::deSerializer(),
        );
    }
}
